#---------------------------------------------------------------------------
# Copyright 2012 The Open Source Electronic Health Record Agent
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#---------------------------------------------------------------------------

#---------------------------------------------------------------------------
# Add location of OSEHRAHelper to the Python path
import sys
sys.path = ['C:/Users/contestant/OSEHRA/Dashboards/OSEHRA-Automated-Testing/Python'] + sys.path
#---------------------------------------------------------------------------

from OSEHRAHelper import PROMPT
from ConnectToVista import ConnectToVista
from InitializeFileman import InitializeFileman
from InitializeDevice import InitializeDevice
from SetupDomain import SetupDomain
from SetupCPRS import SetupCPRS
from AddHolidays import AddHolidays, AddHolidaysByConfig
from StartTaskMan import StartTaskMan
from CreateSystemManager import CreateSystemManager
from AddInstitutions import AddInstitutions, AddInstitutionsByConfig
from AddDivisions import AddDivisions, AddDivisionsByConfig
from AddDoctors import AddDoctors, AddDoctorsByConfig
from AddPatients import AddTestPatients, AddTestPatientsByConfig
from AddClinics import AddClinics, AddClinicsByConfig
from MakeAppointment import MakeAppointment
from VerifyOneAppointment import VerifyOneAppointment
from AddServiceSection import AddServiceSection, AddServiceSectionByConfig
from AddNotificationLetters import AddNotificationLetters, AddNotificationLettersByConfig
from DeleteDBA050 import DeleteDBA050
from AssignNotificationLetter import AssignNotificationLetter
from ReplaceDatabase import ReplaceDatabase
from JSONConfig import JSONConfigParser
from CreateSystemManager import SignInAsSysmtemManager
from AddOnePatient import AddOnePatient, gotoRegisterPatientMenu

""" reset the database """
#ReplaceDatabase()
VistA=ConnectToVista('al_patient.log')
gotoRegisterPatientMenu(VistA)
AddOnePatient(VistA, 'EDWARDS', 'HORACE', 'M', '11/01/1964', '300000002', 'Y', '50')
AddOnePatient(VistA, 'BANKS', 'ALICIA', 'F', '10/03/1966', '300000004', 'Y', '75')
AddOnePatient(VistA, 'BENSON', 'HUGH', 'M', '10/04/1968', '300000006', 'Y', '100')
AddOnePatient(VistA, 'NORTON', 'WADE', 'M', '10/01/1970', '300000008', 'Y', '75')
AddOnePatient(VistA, 'GREER', 'JUANA', 'M', '11/01/1962', '300000000', 'Y', '25')
AddOnePatient(VistA, 'JORDAN', 'LULA', 'F', '05/07/1960', '300000009', 'N', '')
AddOnePatient(VistA, 'HOGAN', 'LONNIE', 'F', '10/01/1963', '300000001', 'N', '')
AddOnePatient(VistA, 'NASH', 'FRANCIS', 'M', '10/01/1965', '300000003', 'N', '')
AddOnePatient(VistA, 'ERICKSON', 'JENNIE', 'F', '12/01/1967', '300000005', 'N', '')
AddOnePatient(VistA, 'BUSH', 'JODI', 'F', '08/01/1969', '300000007', 'N', '')
